//
//  UserDefault.swift
//  Do It
//
//  Created by Jim Dovey on 10/27/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import Foundation

@propertyWrapper struct UserDefault<Value> {
    let key: String
    let defaultValue: Value
    
    init(_ key: String, defaultValue: Value) {
        self.key = key
        self.defaultValue = defaultValue
    }
    
    var wrappedValue: Value {
        get { UserDefaults.standard.object(forKey: key) as? Value ?? defaultValue }
        set { UserDefaults.standard.set(newValue, forKey: key) }
    }
}
